function AISMN_Die::OnEnter(%this, %obj)
{
   %object = GetThisObject(%obj);
   %object.playThread( 0, "fall");
   StopMoving(%obj);
   
   // Remove all task dialog, remove from selection, and disable collision
   echo("!*!*!*  Character in Die::OnEnter");
   %count = ClientGroup.getCount();
   for(%i = 0; %i < %count; %i++) {
      %client = ClientGroup.getObject(%i);
      %ghost  = %client.getGhostID(%object);
      RemoveObjectFromSelection(%ghost);
      DisableCollision(%ghost);
      commandToClient(%client, 'DestroyAllTaskDlg', %ghost);
   }
   
   // remove the bandit from the bandit disaster
   %manager  = $DisasterManager;
   %disaster = %manager.getBanditAttack(%object);
   if (isObject(%disaster))
   {
      %disaster.removeBandit(%object);
      if (isObject(%object.banditTarget))
      {
         %target = %object.banditTarget;
         if (IsUnderAttack(%target) == false)
         {
            // remove the disaster alert if it has not yet been removed
            %message = slgGetUIString("id_bandit_attack_over");
            alertSvrRemoveObject($ALERT_BANDIT, %target, %message);
            
            slgAIManDisasterStealHappiness(%object);

            // check if money should be stolen from the bank
            if (%target.banditSteal == true)
            {
               %money = %disaster.steal();
            }
         }
      }
      if (isObject(%obj.attacker))
      {
         if (!IsUnderAttack(%obj.attacker))
         {
            // remove the disaster alert if it has not yet been removed
            %message = slgGetUIString("id_bandit_attack_over");
            alertSvrRemoveObject($ALERT_BANDIT, %obj.attacker, %message);
         }
      }
   }
}

function AISMN_Die::OnExit(%this,%obj)
{
}

function AISMN_Die::Update(%this,%obj)
{
   %timePassed = TimeInNode(%obj);
   if(%timePassed > 5.0)
      ReturnValue(%obj,0);
   else
      ReturnValue(%obj,-1);
}
